; Cp.asm - Copies one file to another, simple demonstration of file access
;

BUFFER_SIZE equ 1024

%define _WINCONSOLE_
%define _WINNT_
%define _WINIO_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]

procglobal main
	ddlocal		_hStdIn, _hStdOut
	;
	; file handles
	;
	ddlocal		_hFile1, _hFile2
	;
	; number of bytes read into the buffer (static so we can get its address)
	;
	ddstatic	_buffercount
	;
	; buffer for copying the file
	;
	bufflocal	_buffer, BUFFER_SIZE
	endlocals
	;
	sc GetStdHandle, STD_INPUT_HANDLE
	mov	._hStdIn, eax
	sc GetStdHandle, STD_OUTPUT_HANDLE
	mov	._hStdOut, eax
	;
	; Open the file, via CreateFile. This is quite a diverse function, being
	; able to open files, create new ones, set creation flags and share modes
	; and can also open any other type of 'file' resource - pipes, networked
	; files, communication ports, etc. The parameters it takes are:
	;
	;   1. Address of the filename string (null-terminated as per usual)
	;   2. Access mode
	;   3. Share mode
	;   4. Address of the security descriptor (only useful on a filesystem that
	;      supports security, ie NTFS in practice)
	;   5. What to do if the file already exists, or if it doesn't
	;   6. File attributes and flags
	;   7. Handle to a 'template' file for attributes and flags
	;
	; As you can no doubt tell from the above list, this is a powerful function
	; with lots of options. I recommend you check the help file for the full
	; details on it.
	;
	TEXTlocal _szFile1, 'Cp.asm',0
	TEXTlocal _szFile2, 'Cp2.asm',0
	sc CreateFile, ._szFile1, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL
	;
	; After opening the file, we save the file handle for later use
	;
	mov	._hFile1, eax
	;
	; Now open the second file for the copy, with slightly different arguments:
	;
	sc CreateFile, ._szFile2, GENERIC_WRITE, NULL, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL
	;
	; And save its handle
	;
	mov	._hFile2, eax
	;
	; To copy the file, we do a simple read from file1 then write to file2.
	; ReadFile takes five parameters;
	;
	;   1. File handle
	;   2. Address of the buffer to store the read data
	;   3. Number of bytes to read
	;   4. Address of variable to place actual number of bytes read
	;   5. Address of data structure for asynchronous file operations
	;
	sc ReadFile, ._hFile1, ._buffer, BUFFER_SIZE, .._buffercount, NULL
	;
	; If the end of the file's been reached, the number of bytes read
	; will be zero
	;
	while ._buffercount, ne, 0
		;
		; Having read part of the file, we now write it to the other file using
		; WriteFile, which takes five parameters:
		;
		;   1. File handle
		;   2. Address of the buffer holding the data to write
		;   3. Number of bytes to write
		;   4. Address of variable to place actual number of bytes written
		;   5. Address of data structure for asynchronous file operations
		;
		sc WriteFile, ._hFile2, ._buffer, ._buffercount, .._buffercount, NULL
		;
		; and perform another read for the loop
		;
		sc ReadFile, ._hFile1, ._buffer, BUFFER_SIZE, .._buffercount, NULL
	wend
	;
	; Finally, being the good coders we are, we close the files to free up the
	; file handles and any other resources that Windows might have allocated
	; for us. Windows _should_ close all open files when a program terminates,
	; but it's good practice to clean up after ourselves in case it doesn't...
	;
	sc CloseHandle, ._hFile2
	sc CloseHandle, ._hFile1
	sc ExitProcess, 0
[section .bss]

[section .data]
